#pragma GCC target ("avx2")
#pragma GCC optimization ("O3")
#pragma GCC optimization ("unroll-loops")

#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

typedef long long ll;

ll randomn = 423;

ll n, m;
vector<vector<ll>> from, out;
vector<ll> max_path_from_0;
vector<ll> used;
vector<bool> can_reach_0, reacheble_from_0;
vector<ll> p;

void dfs1(ll ind, ll already) {
    randomn++;
    used[ind] = 1;
    for (ll i = randomn; i < randomn + from[ind].size(); i++) {
        if (used[from[ind][i % from[ind].size()]] == 2) {
            if (max_path_from_0[from[ind][i % from[ind].size()]] < already + 1)
                p[from[ind][i % from[ind].size()]] = ind;
            max_path_from_0[from[ind][i % from[ind].size()]] = max(max_path_from_0[from[ind][i % from[ind].size()]], already + 1);
        }
        else if (used[from[ind][i % from[ind].size()]] == 0) {
            if (max_path_from_0[from[ind][i % from[ind].size()]] < already + 1)
                p[from[ind][i % from[ind].size()]] = ind;
            max_path_from_0[from[ind][i % from[ind].size()]] = max(max_path_from_0[from[ind][i % from[ind].size()]], already + 1);
            dfs1(from[ind][i % from[ind].size()], max_path_from_0[from[ind][i % from[ind].size()]]);
        }
    }
    used[ind] = 2;
}
void dfs2(ll ind, ll already) {
    randomn++;
    used[ind] = 1;
    for (ll i = randomn; i < randomn + out[ind].size(); i++) {
        if (used[out[ind][i % out[ind].size()]] == 2) {
            if (max_path_from_0[out[ind][i % out[ind].size()]] < already + 1)
                p[out[ind][i % out[ind].size()]] = ind;
            max_path_from_0[out[ind][i % out[ind].size()]] = max(max_path_from_0[out[ind][i % out[ind].size()]], already + 1);
        }
        else if (used[out[ind][i % out[ind].size()]] == 0) {
            if (max_path_from_0[out[ind][i % out[ind].size()]] < already + 1)
                p[out[ind][i % out[ind].size()]] = ind;
            max_path_from_0[out[ind][i % out[ind].size()]] = max(max_path_from_0[out[ind][i % out[ind].size()]], already + 1);
            dfs2(out[ind][i % out[ind].size()], max_path_from_0[out[ind][i % out[ind].size()]]);
        }
    }
    used[ind] = 2;
}

vector<ll> w;
void write(ll ind) {
    if (ind != -1) {
        w.push_back(ind);
        write(p[ind]);
    }
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    cin >> n >> m;
    from.resize(n); out.resize(n);
    can_reach_0.resize(n); reacheble_from_0.resize(n);
    for (ll i = 0; i < m; i++) {
        ll v, u;
        cin >> v >> u; v--; u--;
        from[v].push_back(u);
        out[u].push_back(v);

        if (u == 0)
            can_reach_0[v] = true;
        if (v == 0)
            reacheble_from_0[u] = true;
    }

    max_path_from_0.resize(n);
    used.resize(n);
    p.resize(n); p[0] = -1;
    dfs1(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs1(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs1(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs1(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs1(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs1(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs1(0, 1);
    
    for (ll i = 0; i < n; i++) {
        if (max_path_from_0[i] == n && can_reach_0[i]) {
            cout << "YES\n";
            write(i);
            for (ll i = 0; i < n; i++)
                cout << w[n-i-1] + 1 << ' ';
            cout << 1;
            return 0;
        }
    }

    fill(max_path_from_0.begin(), max_path_from_0.end(), 0);
    fill(used.begin(), used.end(), 0);
    fill(p.begin(), p.end(), 0); p[0] = -1;
    dfs2(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs2(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs2(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs2(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs2(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs2(0, 1);
    for (ll i = 0; i < n; i++) {
        if (max_path_from_0[i] == n && reacheble_from_0[i]) {
            cout << "YES\n";
            write(i);
            cout << 1 << ' ';
            for (ll i = 0; i < n; i++)
                cout << w[i] + 1 << ' ';
            return 0;
        }
    }

    cout << "NO";

    return 0;
}